%%%%%%%%%%%%%%%% Construct the coauthorship network %%%%%%%%%%%%%%%%%%%%%%%

load('data/AuthorPaperMatrices.mat')

Nauthor = max(AuPap(:,1));
Npaper = max(AuPap(:,2));
X = sparse(AuPap(:,1), AuPap(:,2), 1, Nauthor, Npaper);
A_weighted = X*X';
A = double(A_weighted >0);   %% edge = coauthored at least 1 paper
A = triu(A,1) + tril(A,-1);   %% remove diagonals
clear AuPap;
clear PapPap;
clear A_weighted;
clear X;

[filename, filepath] = uigetfile('data/author_name.txt');
fullname = fullfile(filepath, filename); %%% get the full path (for fopen)
fid=fopen(fullname,'r','n','UTF-8');
data = textscan(fid,'%s','Delimiter',',');
authorNames = data{1};
fclose(fid);
clear data;
clear name;
clear filename;
clear filepath;
clear fullname;
clear fid;

%%%% A: adjacency matrix of the 47311-by-47311 coauthorship network
%%%% authorNames: names of all the 47311 authors













